<?php
/*--------------------------------------------------------------------
 Reader.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Repository\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesValuesIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\ValueModelDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Exceptions\PropertiesValuesIdDoesNotExistExceptions;

/**
 * Class Reader
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Repository\Readers
 */
class Reader implements ReaderInterface
{
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * Reader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function valueModel(PropertiesValuesIdDto $valuesIdDto): ValueModelDto
    {
        $valuesId = $valuesIdDto->propertiesValuesId();
        
        $modelResult = $this->connection->createQueryBuilder()
            ->select('value_model')
            ->from('properties_values')
            ->where('properties_values_id=' . $valuesId)
            ->execute();
        
        if ($modelResult->rowCount() === 0) {
            
            throw new PropertiesValuesIdDoesNotExistExceptions('No entry in Database for properties_values_id ' . $valuesId);
        }
        
        $model = $modelResult->fetch(0)['value_model'];
        
        return new ValueModelDto($model);
    }
}